#!/usr/bin/env python
# -*- coding: utf-8 -*- 
# save_as_png.py
# Provides a simple menu option to save as PNG with
# basic save options and overwrite warning for newly created files.
# Tested in GIMP 2.8.2 on Windows 7 (64 and 32-bit)
# Contact: Kevin Thomer (Defron) | http://blog.defron.org/
# Provided free and as-is under GPL v2.
#
# Based off of:
# save_as_jpg.py
# version 1.0 [gimphelp.org]
# last modified/tested by Paul Sherman
# 12/20/2012 on GIMP-2.8
#
# ==== Original Information ====================================================
# Save or export the current image -- do the right thing whether it's
# XCF (save) or any other format (export). This will mark the image clean,
# so GIMP won't warn you when you exit.
# Warning: this does not show a lot of extra dialogs, etc. or warn you
# if you're about to overwrite something! Use with caution.

# Copyright 2012 by Akkana Peck, http://www.shallowsky.com/software/
# You may use and distribute this plug-in under the terms of the GPL v2
# or, at your option, any later GPL version.
# ========================================================

from gimpfu import *
import gtk
import os, sys
import collections

def python_export_clean(img, drawable, interlace, background, compression) :
	filename = img.filename
	#These typecasts isn't really necessary in Python, just a habit of mine
	bg = int(background)
	interlacing = int(interlace)
#	fullpath = pdb.gimp_image_get_uri(img) Ta procedura zwraca URI powiązanych 
#   z określonym obrazem. Obraz ma URI tylko wtedy, gdy został załadowany lub 
#   importowany z pliku lub został już zapisany, czy eksportowany. 
#   W przeciwnym razie funkcja zwraca %NULL.
#	pdb.gimp_message(filename)

	if not filename :
		chooser = gtk.FileChooserDialog(
			title=None,action=gtk.FILE_CHOOSER_ACTION_SAVE,
			buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_SAVE,gtk.RESPONSE_OK)
			)
		# save folder will be desktop folder zapisu na pulpicie
		save_dir = os.path.join(os.path.expanduser('~'), 'Desktop')
			
		chooser.set_current_folder(save_dir)
		chooser.set_current_name("UNTITLED.png")
		chooser.set_do_overwrite_confirmation(True)
		
		filter = gtk.FileFilter()
		filter.set_name("Save as png")
		filter.add_pattern("*.png")
		chooser.add_filter(filter) 
		
		response = chooser.run()
		if response != gtk.RESPONSE_OK:
			return
		filename = chooser.get_filename()
		img.filename = filename
		chooser.destroy()
	
		pdb.file_png_save(img, drawable, filename, filename, interlacing, compression, bg, 0, 0, 1, 1)
		pdb.gimp_image_clean_all(img)		
			
		
	else:
		base = os.path.splitext(filename)[0]
		newname = base + ".png"

		pdb.gimp_edit_copy(img.active_drawable)
		image2 = pdb.gimp_edit_paste_as_new()
		pdb.file_png_save(image2, drawable, newname, newname, interlacing, compression, bg, 0, 0, 1, 1)
		pdb.gimp_image_delete(image2)		
		pdb.gimp_image_clean_all(img)


register(
		"save_as_png",
		"Zapisanie obrazu jako plik PNG, \nustawianie przeplotu i \nzapisywanie koloru Tła",
		"Zapisanie obrazu jako plik PNG, ustawianie przeplotu i zapisywanie koloru Tła. Aby uzyskać więcej opcji w ochronie pliku przed nadpisywaniem, użyj menu Plik => Wyeksportuj jako..., gdy zapisujesz jako PNG",
		"Kevin Thomer (Defron)",
		"GPL",
		"2013",
		"Save as PNG",
		"*",
		[
			(PF_IMAGE, "image", "Input image", None),
			(PF_DRAWABLE, "drawable", "Input drawable", None),
			(PF_TOGGLE, "interlace", "Przeplatanie (Adam7)", 0),
			(PF_TOGGLE, "background", "Zapisanie koloru Tła", 1),
			(PF_SLIDER, "Compression", "Ustaw poziom kompresji PNG ", 9, (0, 9, 1) )
		],
		[],
		python_export_clean,
		menu="<Image>/File/Save/"
)

main()